<?php
// Inicia a sessão para acessar os dados do usuário.
session_start();

// Verifica se o usuário está logado e se o perfil é de professor.
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'PROFESSOR') {
    header("Location: login.php");
    exit;
}

// Inclui o arquivo de conexão com o banco de dados.
include 'conexao.php';
// Inclui o arquivo que verifica o login, se necessário.
include 'verifica_login.php';

// Obtém os dados do usuário da sessão.
$usuario = $_SESSION['usuario'];
$nome_usuario = $usuario['nome'] ?? 'Professor';

// Lógica de processamento do formulário de upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['documento'])) {
    // Aqui você colocaria a lógica de upload e salvamento no banco de dados.
    // Exemplo:
    // $nome_arquivo = $_FILES['documento']['name'];
    // $caminho_temporario = $_FILES['documento']['tmp_name'];
    // $destino = 'uploads/catedras/' . $nome_arquivo;
    //
    // if (move_uploaded_file($caminho_temporario, $destino)) {
    //     echo "<script>alert('Documento enviado com sucesso!');</script>";
    // } else {
    //     echo "<script>alert('Erro ao fazer o upload do documento.');</script>";
    // }
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload Cátedra - SISMAG</title>
    <link rel="stylesheet" href="https://rsms.me/inter/inter.css">
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-8">

<div class="max-w-4xl mx-auto bg-white p-6 rounded-xl shadow-md">
    <h1 class="text-2xl font-bold text-gray-800 mb-6">Upload Cátedra</h1>
    <p class="text-gray-600 mb-4">Olá, professor(a) <?= htmlspecialchars($nome_usuario) ?>. Use este formulário para fazer upload de um novo material de cátedra.</p>

    <form action="upload_catedra.php" method="POST" enctype="multipart/form-data" class="space-y-4">
        <div>
            <label for="titulo" class="block text-sm font-medium text-gray-700">Título do Documento</label>
            <input type="text" id="titulo" name="titulo" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm" placeholder="Ex: Planificação Anual de Matemática" required>
        </div>
        <div>
            <label for="documento" class="block text-sm font-medium text-gray-700">Selecione o Arquivo</label>
            <input type="file" id="documento" name="documento" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100" required>
        </div>
        <div>
            <button type="submit" class="w-full inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                Fazer Upload
            </button>
        </div>
    </form>
</div>

</body>
</html>


